﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.TBI;

public partial class AdminEditInstruments : BasePage {

    #region Member Variables

    private string _currentRegistry = Helpers.GetConfigEntry("Registry");

    USER userEntry;
    UsersManager usersManager = new UsersManager();

    #endregion

    #region Override Methods

    public override string TopMenuName() {
        return "Administration";
    }

    public override string MenuItemName() {
        return "TBI ADMIN INSTRUMENTS";
    }

    public override string AppObjectCode() {
        return "TBI ADMIN INSTRUMENT LIST";
    }

    #endregion

    /// <summary>
    /// Pre-Render Method
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    void Page_PreRender(object sender, EventArgs e) {
        if (userEntry != null) {
            //This is the last event in the page life cycle where changes can be made to the page object
            //so enforce business rules on the object (which could possibly change the propertie of the object
            //then load the form controls from the object

            //Enforce business rules on the referral object
            //need to call EnforceBusinessRules method in the ReferralManager because some rules require a database call
            //pass in the local instance of referral to the method.  The method will return the object with modifications due to business rules.
            if (IsPostBack) {
                int ret;
                ret = usersManager.EnforceBusinessRules(ref userEntry);
            }
        }
    }

    #region Protected Methods

    /// <summary>
    /// Page Load Method
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e) {

        lblErrorText.Text = "";

        if (!IsPostBack) {
            HiddenFieldBreadCrumbBaseText.Value = LabelBreadCrumb.Text;

            //if page is loading for first time get ID from querystring and set to hidden field to use on postbacks
            int? userID = Convert.ToInt32(Request.QueryString["id"]);
            HiddenFieldUserID.Value = userID.GetValueOrDefault().ToString();


            // bind grid
            PopulateGrid();
        }
        //    HiddenFieldBreadCrumbBaseText.Value = LabelBreadCrumb.Text;

        //    //if page is loading for first time get ID from querystring and set to hidden field to use on postbacks
        //    int? userID = Convert.ToInt32(Request.QueryString["id"]);
        //    HiddenFieldUserID.Value = userID.GetValueOrDefault().ToString();

        //    //Check if the request is to create a new item
        //    //a new item page request is signified when the querystring parameter id equals zero or is not present
        //    if (userID == null || userID == 0) {
        //        //set userID to zero so that a default linq entity will be instantiated
        //        userID = 0;

        //        //set page display for new item
        //        SetFormDisplay(true);

        //    } else {
        //        //set page to display for existing item
        //        SetFormDisplay(false);

        //    }

        //}

        //if (IsPostBack && userEntry != null) {
        //    LoadObjectFromControls();
        //}
    }

    /// <summary>
    /// Populate Grid of Instruments ... depending on the active service in the web.config (MDWS or VIA) - use the appropriate service manager.
    /// </summary>
    protected void PopulateGrid() {
        string serviceToUse = Helpers.getCurrentServiceToUse(); // ConfigurationManager.AppSettings["TBIServiceToUse"];
        List<InstrumentType> instruments = new List<InstrumentType>();

        if (!String.IsNullOrEmpty(serviceToUse) && serviceToUse.Contains("VIA"))
        {
            // VIA
            VIAInstrumentsManager _tbiInstrumentManager = new VIAInstrumentsManager();
            instruments = _tbiInstrumentManager.GetAllInstrumentList();
        }
        else
        {
            // MDWS
            TBIInstrumentsManager _tbiInstrumentManager = new TBIInstrumentsManager();
            instruments = _tbiInstrumentManager.GetAllInstrumentList();
        }

        GridViewInstruments.DataSource = instruments;
        GridViewInstruments.DataBind();
    }

    /// <summary>
    /// Fired when IsActive is selected/unselected.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void chkBoxIsActive_CheckedChanged(Object sender, EventArgs e) {
        lblErrorText.Text = "";

        //string test = "";
        CheckBox cb = (CheckBox)sender;
        GridViewRow gvr = (GridViewRow)cb.NamingContainer;

        int surveyTypeId = -1;

        DataKey dk = GridViewInstruments.DataKeys[gvr.DataItemIndex];
        if (dk != null) {
            surveyTypeId = (int)dk.Value;
        }

        try {
            string serviceToUse = Helpers.getCurrentServiceToUse(); // ConfigurationManager.AppSettings["TBIServiceToUse"];

            if (!String.IsNullOrEmpty(serviceToUse) && serviceToUse.Contains("VIA")) {
                // VIA
                VIAInstrumentsManager _tbiInstrumentManager = new VIAInstrumentsManager();
                _tbiInstrumentManager.SetInstrumentActiviationStatus(surveyTypeId, cb.Checked);
            } else {
                // MDWS
                TBIInstrumentsManager _tbiInstrumentManager = new TBIInstrumentsManager();
                _tbiInstrumentManager.SetInstrumentActiviationStatus(surveyTypeId, cb.Checked);
            }

            PopulateGrid();
        } catch (Exception ex) {
            // catch error ... 
            lblErrorText.Text = "Error: " + ex.Message + "<br />";
        }

        //int returnSaveValue = 0;
        //returnSaveValue = usersManager.Update(userEntry);

        //getEntry(Convert.ToInt32(HiddenFieldUserID.Value));
        //var master = (RegistryMaster)Master;
        //master.SetDirtyFlag(false);
    }

    #endregion
}